// Spline Tip Particles.js
//
//
// this is Particle script. place this .js file into ~/Library/Application Support/Cheetah3D/scripts/Particle folder.
//

var RAD = 180/Math.PI;

var Vec3D_len = function() {
    if( arguments.length == 1)
        return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
    var p = arguments[1].sub(arguments[0]);
    return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
        var l = arguments[0].norm();
        if( l != 0) 
            return arguments[0].multiply(1/l);
        return arguments[0];
}

var splHolder = new Array;
var splList = new Array;

function buildUI( obj ) {
    
    obj.setParameter("name", "Spline Tip Particles");
    
    obj.addParameterLink("path", true);
    
    obj.addParameterBool("tip start", 0, 0, 1, true, true);
    obj.addParameterBool("tip end", 1, 0, 1, true, true);
    
    obj.addParameterBool("along spline", 0, 0, 1, true, true);
    
    obj.addParameterFloat("asy. threshold", 0.01, 0.00001, 0.1, true, true);
}

function buildObject( obj ) { 
    //print('----');
    
    var path = obj.getParameter("path");
    
    var threshold = obj.getParameter("asy. threshold");
    
    var ts = obj.getParameter("tip start");
    var te = obj.getParameter("tip end");
    
    var along = obj.getParameter("along spline");
    
    if (! path || path.family() != SPLINEFAMILY) return;
    
    var pcore = path.modCore();
    var pmat = path.objMatrix();
    
    var pathCount = pcore.pathCount();
    var i, j;
    
    if (pathCount < 1) return;
    
    for (i = 0;i < pathCount;i++) {
        splHolder = pcore.cache(i);
        if (!splHolder) break;
        cacheSplineLength();
        var totalLength = calcSplineLength( splHolder, splList );
        
        //print( 'totalLength:'+totalLength );
        var core = obj.core();
        
        if (ts) {
          var p = core.addParticle();
          var vec = pointFromPercentage( 0, pmat );
          
          p.setPosition( vec );
          var asy = asyVecFromPercentage( 0, pmat, threshold );
          var theta = Math.acos( asy.y ) * RAD;
          var phi = Math.atan2( asy.x, asy.z ) * RAD;
          if (along) p.setRotation( new Vec3D( theta, phi, 0 ) );
        }
        
        if (te) {
          var p = core.addParticle();
          var vec = pointFromPercentage( 1, pmat );
          
          p.setPosition( vec );
          var asy = asyVecFromPercentage( 1, pmat, threshold );
          var theta = Math.acos( asy.y ) * RAD;
          var phi = Math.atan2( asy.x, asy.z ) * RAD;
          if (along) p.setRotation( new Vec3D( theta, phi, 0 ) );
        }
    }
}

// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D
function calcSplineLength(points,lst) {
	var l = points.length;
	var i;
	var accum = 0;
	lst[0] = 0;
	for(i=0;i<l-1;i++) {
		var p = points[i+1].sub(points[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		lst[i+1] = accum;
	}
	for(i=0;i<l;i++) {
		lst[i] = lst[i]/accum;
	}
	return accum;
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
    if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
    var i; var hi = splHolder.length - 1; var lo = 0;
    var d = percent;
    while (hi - lo > 1) {
        i = Math.floor((hi+lo)/2);
        if (percent <= splList[i]) {
            hi = i;
            continue;
        }
        if (percent > splList[i]) {
            lo = i;
        }
    }
    i = hi;
    
    var p1 = splHolder[i-1];
    var p2 = splHolder[i];
    //
    d = (d - splList[i-1])/(splList[i] - splList[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return mat.multiply(p1);
}

function asyVecFromPercentage(percent, mat, m) {
    if (1-m > percent) {
        var prePer = percent - m;
        var posPer = percent;
    } else if (m > percent) {
        var prePer = 0;
        var posPer = percent + m;
    } else {
        var prePer = percent - m;
        var posPer = percent + m;
    }
    prePos = pointFromPercentage( prePer, mat );
    posPos = pointFromPercentage( posPer, mat );
    
    var asyVec = posPos.sub(prePos);
    var norm = asyVec.norm();
    
    return (norm == 0)? asyVec.multiply(0) : asyVec.multiply( 1/norm ) ;
}

function cacheSplineLength() {
    var l = splHolder.length;
    var i;

    var accum = 0;
    splList[0] = 0;
    for (i = 0;i < l - 1;i++) {
        var p = splHolder[i+1].sub(splHolder[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        splList[i+1] = accum;
    }
    for (i = 0;i < l;i++) {
        splList[i] = splList[i] / accum;
    }
}


function descVec( vec ) {
    return ( vec.x.toFixed(3) + ', ' + vec.y.toFixed(3) + ', ' + vec.z.toFixed(3) );
}